 ; Ŀ
 ;   Tiger - Line, Polyline, and Carnivore rejoiner.                       
 ;   Copyright 1994, 2007, 2010 by Rocket Software Ltd.                    
 ;   There are a limited number of carnivores with lines on them.          
 ;   Hi-diddly-Hey!  (Added by Samuel)                                     
 ; 
 ; Ŀ
 ;   Shouldn't any line which is entirely under another be erased?         
 ;   Or at least print a warning - don't always want to dispose of         
 ;   overlaid lines - one may be a grid line and one a building edge.      
 ; 
 ; Ŀ
 ;   Will need a routine for rejoining two lines when a block has been     
 ;   removed, which means that it has to be able to join two lines even if 
 ;   they aren't parts of the same segment, presumably by extending each   
 ;   one to the meeting point, i.e. zero chamfering them,                  
 ;   Assume that we will remove a segment - the join in any case version   
 ;   will be a cut down version of this ... or maybe more complicated,     
 ;   since it has to check for a good join and force one if that can't be  
 ;   done.  But it will only do two lines at once, since the result        
 ;   otherwise would be a tangled mess.                                    
 ; 

 ; Ŀ
 ;   Subroutine CI - grdraw circle maker.                                  
 ; 
 (DEFUN CI (pa radd colo / reps angg incr pa1 pa2)
  (setq reps 32)
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (setq pa1 (polar pa angg radd))
  (repeat reps
          (setq angg (+ angg incr))
          (setq pa2 (polar pa angg radd))
          (grdraw pa1 pa2 colo)
          (setq pa1 pa2))
 (princ))
 ; Ŀ
 ;   Ci end.                                                               
 ; 

 ; Ŀ
 ;   Disz: list all of the distances between the points in a list.         
 ;   Arguments: Plist, a list of points.                                   
 ;   Returns a list of distances.                                          
 ;   Useful, but not currently called.                                     
 ; 
 (DEFUN DISZ (plist / fnum pa num pb dislis)
  (setq fnum 0)
  (while (setq pa (nth fnum plist))
 ; Ŀ
 ;   Start each time at the second segment sublist.                        
 ; 
         (setq num (1+ fnum))
         (while (setq pb (nth num plist))
                (setq num (1+ num))
                (setq dislis (cons (distance pa pb) dislis)))
         (setq fnum (1+ fnum)))
 dislis)
 ; Ŀ
 ;   Disz end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Endzo - make a list of the ename and endpoints of each     
 ;   end segment of a line, polyline, or lwpolyline.                       
 ;   List format: (ename  free_end  attached_end  start_or_end_or_line).   
 ;   In the case of a line or single segment polyline the two lists        
 ;   contain the same two points in two opposite orders.                   
 ;   Modified: there is now a fourth element in each list, either          
 ;   "start", "end", or "line".                                            
 ; 
 (DEFUN ENDZO (enam / esav entt typ num sub tenlst suba enam ten elv)
  (setq esav enam)
  (setq entt (entget enam))
  (setq typ (cdr (assoc 0 entt)))
 ; Ŀ
 ;   The entity was a lwpolyline.  List format:                            
 ;    ename - the entity ename.                                            
 ;    free_end_pos - the free end position.                                
 ;    attached_end_pos - the attached end position.                        
 ;    start_or_end - this segment is the lwpline "start" or "end".         
 ;    nth_10_f - number of 10 groups up to and including the free end one. 
 ;    nth_10_a - no. of 10 groups up to and inc. the attached end one.     
 ; 
  (cond ((= typ "LWPOLYLINE")
         (setq num 0)
         (while (setq sub (nth num entt))
                (if (= (car sub) 10)
                    (setq tenlst (cons (cdr sub) tenlst)))
                (setq num (1+ num)))
         (setq suba (list (list esav (car tenlst) (cadr tenlst) "end"
                                                              num (1- num))))
         (setq tenlst (reverse tenlst))
         (setq suba (append suba (list (list esav (car tenlst) 
                                               (cadr tenlst) "start" 0 1)))))
 ; Ŀ
 ;   The entity was a polyline.                                            
 ;   (ename free_end_pos attached_end_pos start_or_end free_enam ach_enam) 
 ; 
        ((= typ "POLYLINE")
         (while (/= "SEQEND" (cdr (assoc 0
                             (setq entt (entget (setq enam (entnext enam)))))))
                (setq tenlst (cons (list (cdr (assoc 10 entt)) enam) tenlst)))
         (setq suba (list (list esav (caar tenlst) (caadr tenlst) "end"
                                              (cadar tenlst) (cadadr tenlst))))
         (setq tenlst (reverse tenlst))
         (setq suba (append suba (list (list esav (caar tenlst) (caadr tenlst)
                                    "start" (cadar tenlst) (cadadr tenlst))))))
 ; Ŀ
 ;   The entity was a line.                                                
 ;   (ename free_end_pos attached_end_pos "line" f_10_or_11 a_10_or_11)    
 ; 
        ((= typ "LINE")
         (setq ten (cdr (assoc 10 entt)))
         (setq elv (cdr (assoc 11 entt)))
         (setq suba (list (list enam ten elv "line" 10 11)
                          (list enam elv ten "line" 11 10)))))
 suba)
 ; Ŀ
 ;   Endzo end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Glent: Count the segments in a Polyline, LwPolyline, or    
 ;   line.                                                                 
 ;   Takes one argument, an ename.                                         
 ;   Returns the number of segments or -1 if the entity wasn't a pline.    
 ; 
 (DEFUN GLENT (enam / entt typ num sub nums)
  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
  (setq num -1)
  (cond ((= typ "POLYLINE")
         (while (/= "SEQEND" (cdr (assoc 0 (entget (setq enam
                                                           (entnext enam))))))
                (setq num (1+ num))))
        ((= typ "LWPOLYLINE")
         (setq nums 0)
         (while (setq sub (nth nums entt))
                (setq nums (1+ nums))
                (if (= (car sub) 10)
                    (setq num (1+ num)))))
        ((= typ "LINE")
         (setq num 1)))
 num)
 ; Ŀ
 ;   Glent end.                                                            
 ; 

 ; Ŀ
 ;   Goto - grdraw an arrow.                                               
 ;   Arguments: aa, the point to which the arrow points.                   
 ;              bb, the other end of the arrow                             
 ;              colo, the arrow colour.                                    
 ;              hi, highlight the arrow if /= 0.                           
 ;   Notes:                                                                
 ;   1. any negative colour is equivalent to xor colour - dashed white -   
 ;      which erases itself on overwrite.                                  
 ;   2. 0 erases whatever is under it, and is undocumented.                
 ;   3. Highlighting must be turned on in the first grdraw call in the     
 ;      routine, and can't be turned off in the routine.                   
 ;   These may just be anomalies in this video system.                     
 ; 
 (DEFUN GOTO (aa bb colo hi / rad basic dist bhasic ang pa pb1 pb2)
  (setq rad (/ (getvar "viewsize") 20))
  (setq basic (/ (setq dist (distance aa bb)) 4))
  (if (> basic rad) (setq basic rad))
  (if (> basic (* dist 0.75)) (setq basic (* dist 0.75)))
  (setq bhasic (/ basic 2.25))
  (setq ang (angle aa bb))
  (setq pa (polar aa ang basic))
  (setq pb1 (polar pa (+ ang (/ pi 2)) bhasic))
  (setq pb2 (polar pa (+ ang (* pi 1.5)) bhasic))
  (grdraw aa pb1 colo hi) ; hilight must be in first call, doesn't turn off
  (grdraw pb1 pb2 colo)
  (grdraw aa pb2 colo)
  (grdraw bb pa colo)
 ; (grdraw aa pa 0) ; erase line within arrowhead
 (princ))
 ; Ŀ
 ;   Goto end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Isnext - see if an entity follows another directly.        
 ;   Arguments: Enam, the first entity name.                               
 ;              Enxtp, the possible next entity.                           
 ;   Returns T if Enxtp directly follows Enam, else nil.                   
 ;   Caution: ok for inserts, lw/p/lines, not tested for all entity types. 
 ; 
 (DEFUN ISNEXT (enam enextp / typp penam)
  (setq typp (cdr (assoc 0 (entget enam))))
  (if (member typp '("INSERT" "POLYLINE"))
      (while (/= "SEQEND" (cdr (assoc 0 (entget (setq enam (entnext enam)))))))
      (setq enam (entnext enam)))
  (equal enam enextp))
 ; Ŀ
 ;   Isnext end.                                                           
 ; 

 ; Ŀ
 ;   Kfvrtp: remove the first vertex from a polyline.                      
 ;   Argument: Enam, an lwpolyline entity name.                            
 ;   Calls nothing, Returns the new endpoint.                              
 ; 
 (DEFUN KFVRTP (enam / pa)
  (setq pa (cdr (assoc 10 (entget (entnext (entnext enam))))))
  (command ".pedit" enam "e" "s" "n" "n" "g" "p" "m" pa "x" "")
 pa)
 ; Ŀ
 ;   Kfvrtp end.                                                           
 ; 

 ; Ŀ
 ;   Klvrtp: remove the last vertex from a polyline.                       
 ;   Argument: Enam, an lwpolyline entity name.                            
 ;   Calls nothing, Returns the new endpoint.                              
 ; 
 (DEFUN KLVRTP (enam / esav num entt palis pa)
  (setq esav enam)
  (setq num -1)
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                               (setq enam (entnext enam)))))))
         (setq num (1+ num))
         (setq palis (append palis (list (list num (cdr (assoc 10 entt)))))))
  (setq pa (cadr (assoc (1- num) palis)))
  (command ".pedit" esav "e")
  (repeat num (command "n"))
  (command "s" "p" "p" "g" "n" "m" pa "x" "")
 pa)
 ; Ŀ
 ;   Klvrtp end.                                                           
 ; 

 ; Ŀ
 ;   Kfvrtx: remove the first vertex from a lwpolyline.                    
 ;   Argument: Enam, an lwpolyline entity name.                            
 ;   Calls nothing, Returns the new endpoint.                              
 ; 
 (DEFUN KFVRTX (enam / num entt sub malist subten gnulst pa)
  (setq num 0)
  (setq entt (entget enam))
  (while (setq sub (nth num entt))
         (setq num (1+ num))
         (if (= (car sub) 10)
             (progn
                  (setq malist (cons subten malist))
                  (setq subten (list sub)))
             (setq subten (append subten (list sub)))))
  (setq malist (reverse (cons subten malist)))
  (setq gnulst (car malist))
  (setq malist (cddr malist))
  (setq pa (cdaar malist))
  (while (setq sub (car malist))
         (setq gnulst (append gnulst sub))
         (setq malist (cdr malist)))
  (entmod gnulst)
 pa)
 ; Ŀ
 ;   Kfvrtx end.                                                           
 ; 

 ; Ŀ
 ;   Klvrtx: remove the last vertex from a lwpolyline.                     
 ;   Argument: Enam, an lwpolyline entity name.                            
 ;   Calls nothing, Returns the new endpoint.                              
 ;   Written at about 4:45am, sorry about the code.                        
 ; 
 (DEFUN KLVRTX (enam / num entt sub malist subten cut pa gnulst)
  (setq num 0)
  (setq entt (entget enam))
  (while (setq sub (nth num entt))
         (setq num (1+ num))
         (if (member (car sub) '(10 210))
             (progn
                  (setq malist (cons subten malist))
                  (setq subten (list sub)))
             (setq subten (append subten (list sub)))))
  (setq malist (cons subten malist))
  (setq num 0)
  (while (setq sub (nth num malist))
         (setq num (1+ num))
         (cond ((and (null cut) (= (caar sub) 10))
                (setq cut t))
               ((and (null pa) (= (caar sub) 10))
                (setq pa (cdaar sub))
                (setq gnulst (append gnulst (list sub))))
               (t
                (setq gnulst (append gnulst (list sub))))))
  (setq gnulst (reverse gnulst))
  (setq malist (car gnulst))
  (setq gnulst (cdr gnulst))
  (while (setq sub (car gnulst))
         (setq malist (append malist sub))
         (setq gnulst (cdr gnulst)))
  (entmod malist)
 pa)
 ; Ŀ
 ;   Klvrtx end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Lastv - returns the ename of the last vertex of the        
 ;   polyline whose ename was passed as the sole argument.                 
 ; 
 (DEFUN LASTV (enam / goon next typp)
  (setq goon T)
  (while (and goon
              (setq typp (cdr (assoc 0 (entget (setq next (entnext enam)))))))
         (if (= typp "SEQEND")
             (setq goon ())
             (setq enam next)))
 enam)
 ; Ŀ
 ;   Lastv end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Okapi - do the actual join.                                
 ;   Arguments: Lin1, the data list (not entget) for the first lw/p/line.  
 ;              Lin2, the data list for the second lw/p/line.              
 ;   Returns nothing.                                                      
 ;   Calls a number of things.  Probably.                                  
 ; 
 (DEFUN OKAPI (lin1 lin2 / typ1 enam1 entt typ2 enam2 segs2 stend1 stend2 pa)
 ; Ŀ
 ;   There are two overall cases.                                          
 ;   1: #2 has one segment, so it is erased and the segment we are         
 ;   dealing with from #1 is changed to where its attached end was.        
 ;   2: It has > 1 segment, so the appropriate one on #2 is removed and    
 ;   the free end of the segment on #1 is changed to meet #2 and they are  
 ;   joined.                                                               
 ; 
 ; Ŀ
 ;   Get lw/poly/line 1 data.                                              
 ;   The end of the segment which is the end of the polyline is the free   
 ;   end, the other one is the attached end, these are always in the list  
 ;   in this order as nth 1 and nth 2.  This is the same for a line        
 ;   although there is technically no attached end, because the second     
 ;   one contains the point which will be the far end of the combined      
 ;   p/line entity.  Nth 4 and nth 5 each contain either 10 or 11, which   
 ;   tells whether the free end and the attached end, respectively, are    
 ;   the 10 or 11 end of the line.                                         
 ;   For polylines this tells the vertex ename of each end, and for        
 ;   lwpolylines the position in the entity data list, counting only       
 ;   ten groups                                                            
 ; 
  (setq typ1 (cdr (assoc 0 (entget (setq enam1 (car lin1))))))
  (setq entt (entget enam1))
 ; Ŀ
 ;   Get line 2 data.                                                      
 ; 
  (setq typ2 (cdr (assoc 0 (entget (setq enam2 (car lin2))))))
  (setq segs2 (glent enam2))  ; number of segments
 ; Ŀ
 ;   Find whether each of the two segments is the start or end.            
 ;   This is "start" or "end", or "line" if the entity is a line.          
 ; 
  (setq stend1 (cadddr lin1))
  (setq stend2 (cadddr lin2))
 ; Ŀ
 ;   Process the second entity: either delete its first segment or erase   
 ;   it, save the new point - either the far (i.e. attached) end, if a     
 ;   line, or the new free endpoint if something with > 1 vertex.          
 ;   Set the flag Dojoin to T if the entity still exists, else nil.        
 ; 
  (cond ((= segs2 1)
         (entdel enam2)
         (setq pa (nth 2 lin2)))         ; attached end position - same for all
        ((= typ1 "POLYLINE")
         (if (= stend2 "start")          ; kill one end vertex
             (setq pa (kfvrtp enam2))    ; from start
             (setq pa (klvrtp enam2))))  ; from end
        ((= typ1 "LWPOLYLINE")
         (if (= stend2 "start")          ; kill one end vertex
             (setq pa (kfvrtx enam2))    ; from start
             (setq pa (klvrtx enam2))))) ; from end
 ; Ŀ
 ;   Process the first entity - move the free end to the new point.        
 ; 
  (cond ((= typ1 "LINE")
         (if (= 10 (nth 4 lin1))
             (entmod (subst (cons 10 pa) (assoc 10 entt) entt))
             (entmod (subst (cons 11 pa) (assoc 11 entt) entt))))
        ((or (= typ1 "POLYLINE") (= typ1 "LWPOLYLINE"))
         (vrtxpt enam1 pa stend1)
         (entupd enam1)))
 ; Ŀ
 ;   If #2 was not erased (it had > 1 segment) join them, set the flag.    
 ; 
  (if (> segs2 1)
      (pjoinp enam1 enam2 pa))
 (princ))
 ; Ŀ
 ;   Subroutine Okapi end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Pjoinp - join two entities into a pline, see if it worked. 
 ;   Arguments: Enam1, the base entity.                                    
 ;              Enam2, the entity to join to it.                           
 ;              Pa, the join location, strictly for error display.         
 ;   If enam2 still has a corresponding entity then it wasn't joined.      
 ;   Prints an error message if the two weren't joined.                    
 ;   Returns T if they were joined and nil otherwise.                      
 ; 
 (DEFUN PJOINP (enam1 enam2 pa / rad anginc typp1 expp)
 ; Ŀ
 ;   Initialize grdraw marker settings.                                    
 ;   Angg should be global.                                                
 ; 
  (setq rad (/ (getvar "viewsize") 50))
  (if (not (= (type angg) 'real))
      (setq angg 1.5))
  (setq anginc 0.47)
 ; Ŀ
 ;   Join the entities.                                                    
 ; 
  (setq typp1 (cdr (assoc 0 (entget enam1))))
  (if (member typp1 '("POLYLINE" "LWPOLYLINE"))
      (command "pedit" enam1 "j" enam2 "" "")
      (command "pedit" enam1 "y" "j" enam2 "" ""))
 ; Ŀ
 ;   Warn the user if it didn't work, mark the failed join point.          
 ; 
  (if (setq expp (entget enam2))
      (progn
           (prompt "\n**Join Failure - no new polyline segments added.**")
           (radi pa (* rad 0.25) (* rad 1.25) 4 angg 1)
           (setq angg (+ angg anginc))
           (ci pa rad 4)))
 (if expp nil t))
 ; Ŀ
 ;   Pjoinp end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Pointr: see if two lines are colinear and point towards    
 ;   each other.  Note that direction is important.                        
 ;   Arguments: Lin1a, the free end of the first line.                     
 ;              Lin1b, the attached end of the first line.                 
 ;              Lin2a, the free end of the second line.                    
 ;              Lin2b, the attached end of the second line.                
 ;   Returns T or nil.                                                     
 ; 
 (DEFUN POINTR (lin1a lin1b lin2a lin2b / dimscl ang1 ang2 hyp1p2 hyp2p2
                                          inter1 inter2 dist1 dist2 join)
  (if misps
      (setq dimscl (misps))
      (setq dimscl (getvar "dimscale")))
 ; Ŀ
 ;   Brief debug routine.                                                  
 ; 
  (setq debug nil)
  (if debug
      (progn
           (print (equal (distance lin1b lin2b)
                  (+ (distance lin1b lin1a) (distance lin1a lin2b)) 0.0000001))
           (print (equal (distance lin1b lin2b)
                  (+ (distance lin1b lin2a) (distance lin2a lin2b)) 0.0000001))
           (print (<= (distance lin1a lin2a) (distance lin1b lin2b)))))
 ; Ŀ
 ;   Find their angles.                                                    
 ; 
  (setq ang1 (angle lin1a lin1b))
  (setq ang2 (angle lin2a lin2b))
 ; Ŀ
 ;   Make two theoretical lines perpendicular to line 1, each starting at  
 ;   one of its endpoints and with a nominal length of 10 units.           
 ; 
  (setq hyp1p2 (polar lin1a (+ ang1 (/ pi 2)) 10))
  (setq hyp2p2 (polar lin1b (+ ang1 (/ pi 2)) 10))
 ; Ŀ
 ;   Now find the intersection of each hypothetical line with line2.       
 ; 
  (setq inter1 (inters lin2a lin2b lin1a hyp1p2 ()))
  (setq inter2 (inters lin2a lin2b lin2a hyp2p2 ()))
 ; Ŀ
 ;   And thus find the distances between lines 1 and 2 at the ends of      
 ;   line 1.                                                               
 ; 
  (if inter1 (setq dist1 (distance lin1a inter1)))
  (if inter2 (setq dist2 (distance lin2a inter2)))
  (cond ((and (= dist1 0) (= dist2 0))                       ; colinear
         (setq join T))
 ; Ŀ
 ;   The 0.1 in (* 0.1 dimscl) in the next two lines of code is the        
 ;   distance (fraction of dimscale) the two lines can be from true        
 ;   colinearity without being rejected.  This can be adjusted.            
 ; 
        ((and (equal dist1 0 (* 0.1 dimscl))
              (equal dist2 0 (* 0.1 dimscl)))                ; fairly colinear
         (setq join T))
        ((or (null inter1) (null inter2))                    ; perpendicular
         (setq join ()))
        ((equal dist1 dist2 (* dimscl 0.000001))             ; parallel
         (setq join ()))
        (T                                                   ; converge
         (setq join ())))
 ; Ŀ
 ;   More debug stuff.                                                     
 ; 
  (if debug
      (progn
           (print join)
           (getstring "\n*** Continue: ***")))
 ; Ŀ
 ;   If the lines are colinear (Join is t) then check further:             
 ;   - Each of the two inner ends must be between the outer ones - they    
 ;   they are known to be colinear if we are here - so check to see if     
 ;   the case if the distance ab + bc = ac where b is the inner point.     
 ;   - Check for pointing at each other - the free ends must be closer     
 ;   together than the attached ends.                                      
 ;   Note: consider applying a fuzz factor to the distance comparison.     
 ; 
 (and join
      (equal (distance lin1b lin2b)
             (+ (distance lin1b lin1a) (distance lin1a lin2b)) 0.0000001)
      (equal (distance lin1b lin2b)
             (+ (distance lin1b lin2a) (distance lin2a lin2b)) 0.0000001)
      (<= (distance lin1a lin2a) (distance lin1b lin2b))))
 ; Ŀ
 ;   Pointr end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Radi - grdraw radial line set maker.                       
 ;   Does a complete circular set.                                         
 ;   Arguments: Pa, the base point.                                        
 ;              Rin, near end distance.                                    
 ;              Rout, far end distance.                                    
 ;              Reps, number of repetions in 360 degrees.                  
 ;              Stang, the start angle.                                    
 ;              Colo, the colour.                                          
 ;   Calls its mother, returns the empties.                                
 ; 
 (DEFUN RADI (pa rin rout reps stang colo / incr pa1 pa2 stang)
  (setq incr (/ pi (/ reps 2)))
  (repeat reps
          (setq pa1 (polar pa stang rin))
          (setq pa2 (polar pa stang rout))
          (grdraw pa1 pa2 colo)
          (setq stang (+ stang incr)))
 (princ))
 ; Ŀ
 ;   Radi end.                                                             
 ; 

 ; Ŀ
 ;   Remora: remove sublists with a given initial element from a list.     
 ;   Arguments: Suba, a first element.                                     
 ;              Plist, a list of lists.                                    
 ;   Returns a modified list.                                              
 ; 
 (DEFUN REMORA (suba plist / num sub gnulis)
  (setq num 0)
  (while (setq sub (nth num plist))
         (if (/= (car sub) suba)
             (setq gnulis (append gnulis (list sub))))
         (setq num (1+ num)))
 gnulis)
 ; Ŀ
 ;   Remora end.                                                           
 ; 

 ; Ŀ
 ;   Sampt - see if the two ends of a polyline share the same point.       
 ;   Arguments: Enam1, an entity name.                                     
 ;              Fuzz, an acceptable difference.                            
 ;   Returns T, the points are the same, or nil.                           
 ;   Also returns nil if the entity wasn't a polyline or lwpolyline.       
 ; 
 (DEFUN SAMPT (enam fuzz / entt typp venama pa venamb pb ends)
  (setq entt (entget enam))
  (setq typp (cdr (assoc 0 entt)))
  (cond ((= typp "POLYLINE")
         (setq venama (entnext enam))
         (setq pa (cdr (assoc 10 (entget venama))))
         (setq venamb (lastv enam))
         (setq pb (cdr (assoc 10 (entget venamb)))))
        ((= typp "LWPOLYLINE")
         (setq ends (wendy enam))
         (setq pa (car ends))
         (setq pb (cadr ends))))
 (and pa pb (equal pa pb fuzz)))
 ; Ŀ
 ;   Subroutine Sampt end.                                                 
 ; 

 ; Ŀ
 ;   Vrtxpt: move either the first or last vertex in a polyline.           
 ;   Arguments: Enam, a polyline or lwpolyline entity name.                
 ;              Pa, a new point.                                           
 ;              End, either "start" or "end".                              
 ;   Calls nothing, Returns nothing.                                       
 ;   Doesn't Entupd, the calling function must do this for polylines.      
 ; 
 (DEFUN VRTXPT (enam pa end / esav entt typ enam pa num sub stop)
  (setq esav enam)
  (setq entt (entget enam))
  (setq typ (cdr (assoc 0 entt)))
  (cond ((and (= typ "POLYLINE") (= end "start"))
         (setq entt (entget (entnext enam)))
         (entmod (subst (cons 10 pa) (assoc 10 entt) entt)))
        ((and (= typ "POLYLINE") (= end "end"))
         (while (/= "SEQEND" (cdr (assoc 0 (entget (entnext enam)))))
                (setq enam (entnext enam)))
         (setq entt (entget enam))
         (entmod (subst (cons 10 pa) (assoc 10 entt) entt)))
        ((= typ "LWPOLYLINE")
         (if (= (length pa) 3) (setq pa (reverse (cdr (reverse pa)))))
         (if (= end "end") (setq entt (reverse entt)))
         (setq num 0)
         (while (and (null stop) (setq sub (nth num entt)))
                (setq num (1+ num))
                (if (= (car sub) 10)
                    (progn
                         (setq entt (subst (cons 10 pa) sub entt))
                         (setq stop t))))
         (if (= end "end") (setq entt (reverse entt)))
         (entmod entt)))
 (princ))
 ; Ŀ
 ;   Vrtxpt end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Wendy: Find the endpoints of an LwPolyline.                
 ;   Takes one argument, the ename, returns a list of the endpoints.       
 ; 
 (DEFUN WENDY (enam / entt eleva num sub tenlst end1 end2)
  (if (/= (type last) 'SUBR)
      (*error* "Unable to run: Last subroutine has been redefined."))
  (setq entt (entget enam))
  (if (null (setq eleva (cdr (assoc 38 entt))))
      (setq eleva 0))
  (setq num 0)
  (while (setq sub (nth num entt))
         (if (= (car sub) 10)
             (setq tenlst (cons sub tenlst)))
         (setq num (1+ num)))
  (setq end1 (append (cdar tenlst) (list eleva)))
  (setq end2 (append (cdr (last tenlst)) (list eleva)))
 (list end1 end2))
 ; Ŀ
 ;   Wendy end.                                                            
 ; 

 ; Ŀ
 ;   Tiger.                                                                
 ; 
 (DEFUN C:TIGER (/ snapp *error* curlas ss num enam malist lin1 typ1 enam1
              markp end1a end1b joinp lin2 typ2 enam2 end2a end2b segs1 segs2)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "snapmode" snapp)
   (if shk (print shk))
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get the scale, depending on which space we are in and other things.   
 ; 
  (if misps
      (setq dimscl (misps))
      (setq dimscl (getvar "dimscale")))
 ; Ŀ
 ;   Save the name of the last entity.                                     
 ; 
  (setq curlas (entlast))
 ; Ŀ
 ;   Get a selection set of lines and similar entities.                    
 ;   Filter out closed polylines.                                          
 ; 
  (prompt "Select lines:")
  (setq ss (ssget '((-4 . "<or")
                     (-4 . "<and") 
                      (-4 . "<or") (0 . "polyline")
                                   (0 . "lwpolyline") (-4 . "or>")
                      (-4 . "<not") (-4 . "&") (70 . 1) (-4 . "not>")
                     (-4 . "and>")
                     (0 . "line")
                    (-4 . "or>"))))
 ; Ŀ
 ;   Remove any plines which appear closed but aren't , i.e. those which   
 ;   have their start and end at the same point.                           
 ;   *** Hey - this also removes zero length plines.  Is this okay?        
 ;   Can one say which way they point?  Should they exist?                 
 ;   This section can be commented out later if upon cool reflection       
 ;   it turns out to have been the work of a fevered brain.                
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (if (sampt enam (* (misps) 0.01))
             (ssdel enam ss)
             (setq num (1+ num))))
 ; Ŀ
 ;   Make the master list of end segments.                                 
 ;   The sublist design is: (ename  free_end  attached_end  type).         
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq malist (append malist (endzo enam))))
 ; Ŀ
 ;   See if malist is short enough to make pointer marking practical.      
 ; 
 ; (if (< (length malist) 11) (setq markp t))
 ; Ŀ
 ;   While there is > 1 segment, compare and join them.                    
 ; 
  (while (and (> (length malist) 1)
              (setq lin1 (car malist)))
         (setq typ1 (cdr (assoc 0 (entget (setq enam1 (car lin1))))))
         (setq end1a (cadr lin1))    ; free end
         (setq end1b (caddr lin1))   ; attached end
 ; Ŀ
 ;   Start each time at the second segment sublist.                        
 ; 
         (setq num 1)
         (setq joinp nil)                       ; initialize join flag
         (while (and (null joinp) (setq lin2 (nth num malist)))
                (setq num (1+ num))
                (setq typ2 (cdr (assoc 0 (entget (setq enam2 (car lin2))))))
 ; Ŀ
 ;   If there are few enough segments, mark them as they are checked.      
 ; 
                (if markp
                    (progn
                         (goto end1a end1b 1 1)
                         (goto (cadr lin2) (caddr lin2) 2 1)
                         (command "delay" "90")
                         (redraw)))
 ; Ŀ
 ;   Segments can be joined if they point towards each other,              
 ;   and they are different entities, or one of them has more than one     
 ;   segment...of course if they are the same entity they have the same    
 ;   number of segments...                                                 
 ; 
                (if (and (pointr end1a end1b
                                 (setq end2a (cadr lin2))
                                 (setq end2b (caddr lin2)))
                         (or (/= enam1 enam2)
                             (> (glent enam1) 1)     ; number of segments
                             (> (glent enam2) 1)))   ; number of segments
                    (okapi lin1 lin2))
 ; Ŀ
 ;   Okapi should have joined two lines, or erased one and repositioned    
 ;   the other.  This being the case either enam1 or enam2 will have       
 ;   ceased to exist, so set joinp to T and rehash malist.                 
 ;   Note that if the join was unsuccessful then enam1 will still exist,   
 ;   but adding it back to malist seems likely to leave us in a loop.      
 ; 
                (if (or (null (entget enam1))
                        (null (entget enam2)))
                    (progn
                         (setq joinp T)
                         (setq malist (remora enam1 malist))
                         (setq malist (remora enam2 malist))
 ; Ŀ
 ;   Joining a polyline onto a line creates a new entity (the pline        
 ;   doesn't have the same ename as the line it replaces) so if there is   
 ;   one (and it is right after the previous entlast, so that deletion of  
 ;   entlast won't cause the previous entity to be added to malist) add    
 ;   it to malist.                                                         
 ; 
                         (if (isnext curlas (entlast))
                             (setq malist (append malist (endzo (entlast)))))
 ; Ŀ
 ;   Add the other two entities back in if they still exist.               
 ; 
                         (if (entget enam2)
                             (setq malist (append malist (endzo enam2))))
                         (if (entget enam1)
                             (setq malist (append malist (endzo enam1))))
 ; Ŀ
 ;   Save the (possibly new) entlast ename into curlas.                    
 ; 
                         (setq curlas (entlast)))))
 ; Ŀ
 ;   If joinp was nil then Enam1 wasn't joined to anything, remove it      
 ;   from malist.  (Otherwise it will have been added back to the end and  
 ;   enam2 will be part of another entity and it's sublist will have been  
 ;   removed.)                                                             
 ; 
         (if (null joinp) (setq malist (cdr malist))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))